
#ifndef DRAWUTIL_H
#define DRAWUTIL_H


#include "mathutil.h"


void drawBox(
   const AlignedBox& box, bool expand, bool makeItLookCool
);
void drawCircle(
   const Point3& centre,
   const Vector3& normal, // a unit vector normal to the circle's plane
   float radius,
   float arcLengthPerPixel
);
void drawCone(
   const Point3& apex,
   const Vector3& axis, // a unit vector pointing from apex to base
   float semiAngle,
   float lateralLength,
   int nbLateralSides,
   bool drawBase
);
void drawFrame(
   const Point3& origin,
   const Vector3& i, const Vector3& j, const Vector3& k,//must be unit vectors
   float length, bool drawArrowHeads, bool isColoured,
   const Point3& i_colour = Point3(1,0,0), // interpreted as an rgb triple
   const Point3& j_colour = Point3(0,1,0), // interpreted as an rgb triple
   const Point3& k_colour = Point3(0,0,1)  // interpreted as an rgb triple
);
inline void drawAxes( const Point3& origin, float length, bool isColoured ) {
   drawFrame(
      origin, Vector3(1,0,0), Vector3(0,1,0), Vector3(0,0,1),
      length, true, isColoured
   );
}
void drawCrossHairs( const Point3& centre, float radius );
void drawRay( const Ray& ray );


#endif /* DRAWUTIL_H */

