
#ifndef TOOL_H
#define TOOL_H


class Camera;


class Tool {
protected:
   const Camera * _camera;

   // Stores the state of the mouse.
   int _mx, _my;
   bool _LMB, _MMB;
   bool _dragging;

public:
   Tool() :
      _camera( 0 ),
      _LMB( false ), _MMB( false ), _dragging( false )
   { }
   virtual ~Tool() { _camera = 0; }

   void setCamera( const Camera * c ) { _camera = c; }

   enum Status {
      ERROR,
      DONT_REDRAW, // status is okay, but no need to redraw
      REDRAW  // status is okay, and please redraw
   };

   // If the tool can't be activated,
   // this returns ERROR and the manipulation is aborted.
   virtual Status press( int x, int y, bool LMB, bool MMB ) = 0;

   // This is called not only when the mouse is being dragged,
   // but whenever the mouse moves.
   virtual Status move( int x, int y ) = 0;

   // The boolean parameters indicate which buttons are still down.
   virtual Status release( int x, int y, bool LMB, bool MMB ) = 0;

   virtual void draw() = 0;
};


#endif /* TOOL_H */

