
#ifndef SCENE_H
#define SCENE_H


#include "Object.h"


typedef unsigned int OIndex;  // Object Index


class Scene {
private:
   vector< Object* > _objects;
public:
   ~Scene();

   OIndex getNbObjects() const { return _objects.size();  }
   Object * getObject( OIndex i ) const { return _objects[i]; }
   void deleteObject( OIndex i ) {
      vector< Object* >::iterator it = _objects.begin() + i;
      delete *it;
      _objects.erase( it );
   }

   // Scene takes ownership of the object here,
   // and will delete it when the scene is destructed.
   void add( Object* obj ) { _objects.push_back( obj ); }

   enum DrawMode {
      WIREFRAME,
      FLAT_SHADED,
      SMOOTH_SHADED,
      NUM_DRAW_MODES
   };

   void draw( DrawMode drawMode ) const;

   AlignedBox getBoundingBox() const;

   // Returns a list of all the objects intersected.
   // If there are no intersections, returns false.
   bool intersectAll(
      const Ray&, list< OIndex >& objectList, bool cullBackfaces
   );

   // If there are intersections,
   // returns the nearest intersected object and face
   // and the corresponding ray parameter value.
   // If there are no intersections, returns false.
   bool intersectNearest(
      const Ray&, OIndex & object, FIndex & face, float & t, bool cullBackfaces
   );

   // FIXME: not yet implemented
   // void read( char filename[] );
   // void write( char filename[] );
   // void pasteFrom( char filename[] );
};


#endif /* SCENE_H */

