
#ifndef GLOBAL_H
#define GLOBAL_H


#include <stdio.h>   /* printf() */
#ifdef LINUX
#include <stdlib.h>  /* exit() */
#else
#include <unistd.h>  /* exit() */
#endif
#include <math.h>    /* sqrt() */


#define DEBUG


#ifdef DEBUG
   #define ASSERT(exp) { if (!(exp)) { \
      printf( "Assertion error at line %d in %s\n", __LINE__, __FILE__ ); \
      exit( 1 ); \
   }}
#else
   #define ASSERT(exp)
#endif


#ifdef DEBUG
   #define ASSERT_IS_EQUAL(a,b) { \
      ASSERT( (b) - 0.0005 < (a) && (a) < (b) + 0.0005 ); \
   }
#else
   #define ASSERT_IS_EQUAL(a,b)
#endif


#define NORMALIZE(x,y,z) { \
   float norm = sqrt( (x)*(x) + (y)*(y) + (z)*(z) ); \
   (x) /= norm; (y) /= norm; (z) /= norm; \
}


#ifdef DEBUG
   #define ASSERT_IS_NORMALIZED(x,y,z) { \
      float norm_squared = (x)*(x) + (y)*(y) + (z)*(z); \
      ASSERT_IS_EQUAL( norm_squared, 1.0 ); \
   }
#else
   #define ASSERT_IS_NORMALIZED(x,y,z)
#endif


typedef enum { LOW_LOD, MEDIUM_LOD, HIGH_LOD } LevelOfDetail;


void assignToUnity( float matrix[16] );
void copyMatrix( float destination[ 16 ], float source[ 16 ] );
void transposeMatrix( float matrix[ 16 ] );
void assignToTranslation(
   float matrix[16],
   float delta_x, float delta_y, float delta_z
);
void assignToRotation(
   float matrix[16],
   float angle_in_degrees,
   float axis_x, float axis_y, float axis_z
);
void premultiplyWithTranslation(
   float matrix[16],
   float delta_x, float delta_y, float delta_z
);
void premultiplyWithRotation(
   float matrix[16],
   float angle_in_degrees,
   float axis_x, float axis_y, float axis_z
);
void pushLevel(
   float position_x, float position_y, float position_z,
   float direction_x, float direction_y, float direction_z,
   bool isReverse
);
void popLevel();


void drawSphere( float x, float y, float z, float radius, LevelOfDetail LOD );


#endif /* GLOBAL_H */

