
#ifndef TRAINTRACKSWITCH_H
#define TRAINTRACKSWITCH_H


#include "AbstractTrainTrack.h"


class TrainTrackSwitch : public AbstractTrainTrack {

private:
   AbstractTrainTrack *_trackA1, *_trackA2, *_trackB1, *_trackB2;
   TrackEndPoint _endA1, _endA2, _endB1, _endB2;
   bool _isInStateA;
   float _length;
   float _start_x, _start_y, _start_z;
   float _start_direction_x, _start_direction_y, _start_direction_z;
   float _end_x, _end_y, _end_z;

   void computeLength();
public:

   // Defines what tracks are connected in states A and B.
   // Initially the switch is in state A.
   //
   TrainTrackSwitch(
      AbstractTrainTrack * trackA1, TrackEndPoint endA1,
      AbstractTrainTrack * trackA2, TrackEndPoint endA2,
      AbstractTrainTrack * trackB1, TrackEndPoint endB1,
      AbstractTrainTrack * trackB2, TrackEndPoint endB2
   ) :
      _trackA1( trackA1 ), _endA1( endA1 ),
      _trackA2( trackA2 ), _endA2( endA2 ),
      _trackB1( trackB1 ), _endB1( endB1 ),
      _trackB2( trackB2 ), _endB2( endB2 ),
      _isInStateA( true )
   {
      _trackA1->connect( _endA1, this, INITIAL_END_POINT );
      _trackA2->connect( _endA2, this, FINAL_END_POINT );
      computeLength();
   }

   void reset() { if ( ! _isInStateA ) toggle(); }

   virtual float getLength() { return _length; }

   // toggles between states A and B
   //
   void toggle();

   void draw( LevelOfDetail LOD, bool isWireFrame );

   virtual void computePositionAndDirection(
      float distanceAlongSwitch,
      float & x,
      float & y,
      float & z,
      float & direction_x,
      float & direction_y,
      float & direction_z
   );

   virtual void connect(
      TrackEndPoint endToConnect,
      AbstractTrainTrack * trackToConnectTo,
      TrackEndPoint endToConnectTo
   ) {}
   virtual void disconnect( TrackEndPoint endToDisconnect ) {}

   virtual void getConnection(
      TrackEndPoint connectedEnd,
      AbstractTrainTrack * & trackConnectedTo,
      TrackEndPoint & endConnectedTo
   );
};


#endif /* TRAINTRACKSWITCH_H */

