
#ifndef TRAINTRACK_H
#define TRAINTRACK_H


#include "AbstractTrainTrack.h"
class SectionOfTrainTrack;


class TrainTrack : public AbstractTrainTrack {

   typedef SectionOfTrainTrack * SectionOfTrainTrackPtr;

   int _numberOfSections;
   SectionOfTrainTrack ** _arrayOfSections;
   float * _arrayOfCumulativeLengths;

   float _total_length;

   float _start_x;
   float _start_y;
   float _start_z;
   float _start_direction_x;
   float _start_direction_y;
   float _start_direction_z;

   AbstractTrainTrack *_track1, *_track2;
   TrackEndPoint _end1, _end2;
public:
   TrainTrack(
      float start_x,
      float start_y,
      float start_z,
      float start_direction_x,
      float start_direction_y,
      float start_direction_z
   );
   ~TrainTrack();
   void appendStraightSection(
      float length,
      float delta_z   // negative means downward sloping
   );
   void appendCurvedSection(
      float arc_angle_in_degrees,
      float radius,
      float delta_z   // negative means downward sloping
   );
   virtual float getLength() { return _total_length; }
   void draw( LevelOfDetail LOD, bool isWireFrame );
   virtual void computePositionAndDirection(
      float distanceAlongTrack,
      float & x,
      float & y,
      float & z,
      float & direction_x,
      float & direction_y,
      float & direction_z
   );
   virtual void connect(
      TrackEndPoint endToConnect,
      AbstractTrainTrack * trackToConnectTo,
      TrackEndPoint endToConnectTo
   );
   virtual void disconnect( TrackEndPoint endToDisconnect );
   virtual void getConnection(
      TrackEndPoint connectedEnd,
      AbstractTrainTrack * & trackConnectedTo,
      TrackEndPoint & endConnectedTo
   );
private:
   void computeStartingPositionAndDirectionForNewSection(
      float & start_x,
      float & start_y,
      float & start_z,
      float & start_direction_x,
      float & start_direction_y,
      float & start_direction_z
   );
   void appendSection( SectionOfTrainTrack * section );
};


#endif /* TRAINTRACK_H */

