
#ifndef TRAINCAR_H
#define TRAINCAR_H


#include "global.h"
class AbstractTrainTrack;


class TrainCar {
public:

   typedef enum {
      LOCOMOTIVE,
      FREIGHT_CAR,
      CABOOSE
   } TrainCarType;

   typedef enum {
      FORWARD_DIRECTION, BACKWARD_DIRECTION
   } TrainCarDirection;

private:

   TrainCarType _carType;
   float _length, _height;

   AbstractTrainTrack *_track;
   float _distanceAlongTrack;
   TrainCarDirection _directionAlongTrack;

   float _midpoint_x, _midpoint_y, _midpoint_z;
   float _direction_x, _direction_y, _direction_z;

   float _colourRed, _colourGreen, _colourBlue;

   void computePositionAndDirection();
public:

   TrainCar(
      TrainCarType carType,
      AbstractTrainTrack * track,
      float distanceAlongTrack,
      TrainCarDirection directionAlongTrack,
      float colourRed, float colourGreen, float colourBlue
   ) :
      _carType( carType ), _length( 2.0 ), _height( 1.5 ),
      _track( track ), _distanceAlongTrack( distanceAlongTrack ),
      _directionAlongTrack( directionAlongTrack ),
      _colourRed( colourRed ),
      _colourGreen( colourGreen ),
      _colourBlue( colourBlue )
   {
      computePositionAndDirection();
   }

   void advance( float distance );

   void draw( LevelOfDetail LOD, bool isWireFrame );

   void getPosition( float & x, float & y, float & z ) const {
      x = _midpoint_x;   y = _midpoint_y;   z = _midpoint_z;
   }
   void getDirection( float & d_x, float & d_y, float & d_z ) const {
      d_x = _direction_x;   d_y = _direction_y;   d_z = _direction_z;
   }

   TrainCarType getCarType() const { return _carType; }
   float getLength() const { return _length; }
   float getHeight() const { return _height; }
   AbstractTrainTrack * getAbstractTrainTrack() { return _track; }
   float getDistanceAlongTrack() { return _distanceAlongTrack; }
   TrainCarDirection getDirectionAlongTrack() { return _directionAlongTrack; }
};


#endif /* TRAINCAR_H */

