
#include "TrainCar.h"
#include "AbstractTrainTrack.h"
#include <GL/gl.h>


void TrainCar::computePositionAndDirection() {

   float x, y, z;

   _track->computePositionAndDirection(
      _distanceAlongTrack,
      x, y, z,
      _direction_x, _direction_y, _direction_z
   );
   if ( BACKWARD_DIRECTION == _directionAlongTrack ) {
      _direction_x = - _direction_x;
      _direction_y = - _direction_y;
      _direction_z = - _direction_z;
   }

   _midpoint_x = x;
   _midpoint_y = y;
   _midpoint_z = z;
}

void TrainCar::advance( float distance ) {

   bool distanceIsPositive = ( 0.0 < distance );
   distance = fabs( distance );

   if (
      ( FORWARD_DIRECTION == _directionAlongTrack )
      == ( distanceIsPositive )
   ) {
      _distanceAlongTrack += distance;
      if ( _distanceAlongTrack > _track->getLength() ) {
         AbstractTrainTrack * newTrack;
         AbstractTrainTrack::TrackEndPoint end;
         _track->getConnection(
            AbstractTrainTrack::FINAL_END_POINT,
            newTrack, end
         );
         if ( NULL != newTrack ) {
            distance = _distanceAlongTrack - _track->getLength();
            _track = newTrack;
            if ( AbstractTrainTrack::INITIAL_END_POINT == end ) {
               _distanceAlongTrack = 0.0;
               _directionAlongTrack = distanceIsPositive
                  ? FORWARD_DIRECTION : BACKWARD_DIRECTION;
            }
            else {
               _distanceAlongTrack = _track->getLength();
               _directionAlongTrack = distanceIsPositive
                  ? BACKWARD_DIRECTION : FORWARD_DIRECTION;
            }
            advance( distanceIsPositive ? distance : - distance );
            return;
         }
      }
   }
   else {
      _distanceAlongTrack -= distance;
      if ( _distanceAlongTrack < 0.0 ) {
         AbstractTrainTrack * newTrack;
         AbstractTrainTrack::TrackEndPoint end;
         _track->getConnection(
            AbstractTrainTrack::INITIAL_END_POINT,
            newTrack, end
         );
         if ( NULL != newTrack ) {
            distance = - _distanceAlongTrack;
            _track = newTrack;
            if ( AbstractTrainTrack::INITIAL_END_POINT == end ) {
               _distanceAlongTrack = 0.0;
               _directionAlongTrack = distanceIsPositive
                  ? FORWARD_DIRECTION : BACKWARD_DIRECTION;
            }
            else {
               _distanceAlongTrack = _track->getLength();
               _directionAlongTrack = distanceIsPositive
                  ? BACKWARD_DIRECTION : FORWARD_DIRECTION;
            }
            advance( distanceIsPositive ? distance : - distance );
            return;
         }
      }
   }

   computePositionAndDirection();
}

void TrainCar::draw( LevelOfDetail LOD, bool isWireFrame ) {

   GLfloat carColour[] = { _colourRed, _colourGreen, _colourBlue, 1.0 };

   pushLevel(
      _midpoint_x, _midpoint_y, _midpoint_z,
      _direction_x, _direction_y, _direction_z,
      false
   );

   if ( LOCOMOTIVE == _carType ) {

      const float width = 1.0;
      const float noseLength = 0.5*_length;
      const float cabinLength = 0.2*_length;
      const float smokeStackRadius = 0.1*_length;
      float x = 0.5*width;
      float y = 0.5*_length;
      float y2 = -y + cabinLength;
      float y3 = y - 3.0 * smokeStackRadius;
      float y4 = y + noseLength;
      float z1 = 0.2*_height;
      float z2 = 0.6*_height;
      float z3 = z1 + _height;

      float N1[] = { 0.0, y4, z1 };
      float N2[] = { 0.0, y, z2 };
      float N3[] = { -x, y, z1 };
      float N4[] = { x, y, z1 };
      float N5[] = { -x, y, z2 };
      float N6[] = { x, y, z2 };

      float S1[] = { 0.0, y3 + smokeStackRadius, z3 };
      float S2[] = { 0.0, y3 - smokeStackRadius, z3 };
      float S3[] = { - smokeStackRadius, y3, z3 };
      float S4[] = { smokeStackRadius, y3, z3 };
      float S5[] = { 0.0, y3 + smokeStackRadius, z2 };
      float S6[] = { 0.0, y3 - smokeStackRadius, z2 };
      float S7[] = { - smokeStackRadius, y3, z2 };
      float S8[] = { smokeStackRadius, y3, z2 };

      float C1[] = { -x, y2, z3 };
      float C2[] = { x, y2, z3 };
      float C3[] = { -x, y2, z2 };
      float C4[] = { x, y2, z2 };

      float B1[] = { -x, -y, z3 };
      float B2[] = { x, -y, z3 };
      float B3[] = { -x, -y, z1 };
      float B4[] = { x, -y, z1 };

      if ( LOW_LOD != LOD ) {
         // this is gourmet : smoke puffs !

         const int nbPuffs = 3;  // number of puffs
         const float interPuffDist = _length;  // distance between puffs
         const float r0 = 0.5*_height;  // initial radius of puff
         float r;

         float delta = fmod( _distanceAlongTrack, interPuffDist );
         if ( BACKWARD_DIRECTION == _directionAlongTrack )
            delta = interPuffDist - delta;
         for ( int i = 0; i < nbPuffs; ++i ) {
            float s = (interPuffDist*nbPuffs-delta) / (interPuffDist*nbPuffs);
            r = r0 * s;
            GLfloat smokeColour[] = { s, s, s, 1.0 };
            glMaterialfv( GL_FRONT, GL_AMBIENT_AND_DIFFUSE, smokeColour );
            drawSphere( 0.0, y3 - delta, z3 + 0.7*_height, r, LOD );
            delta += interPuffDist;
         }
      }

      glMaterialfv( GL_FRONT, GL_AMBIENT_AND_DIFFUSE, carColour );

      glBegin( GL_QUADS );
         glNormal3f( 0.0, 0.0, 1.0 );
         glVertex3fv( N5 );
         glVertex3fv( C3 );
         glVertex3fv( C4 );
         glVertex3fv( N6 );

         glVertex3fv( C1 );
         glVertex3fv( B1 );
         glVertex3fv( B2 );
         glVertex3fv( C2 );

         glVertex3fv( S1 );
         glVertex3fv( S3 );
         glVertex3fv( S2 );
         glVertex3fv( S4 );

         glNormal3f( 0.0, -1.0, 0.0 );
         glVertex3fv( B2 );
         glVertex3fv( B1 );
         glVertex3fv( B3 );
         glVertex3fv( B4 );

         glNormal3f( 0.0, 1.0, 0.0 );
         glVertex3fv( N3 );
         glVertex3fv( N5 );
         glVertex3fv( N6 );
         glVertex3fv( N4 );

         glVertex3fv( C1 );
         glVertex3fv( C2 );
         glVertex3fv( C4 );
         glVertex3fv( C3 );

         // glNormal3f( - M_SQRT1_2, M_SQRT1_2, 0.0 );
         glNormal3f( 0.0, 1.0, 0.0 );
         glVertex3fv( S1 );
         glVertex3fv( S5 );
         glNormal3f( -1.0, 0.0, 0.0 );
         glVertex3fv( S7 );
         glVertex3fv( S3 );

         // glNormal3f( M_SQRT1_2, M_SQRT1_2, 0.0 );
         glNormal3f( 1.0, 0.0, 0.0 );
         glVertex3fv( S4 );
         glVertex3fv( S8 );
         glNormal3f( 0.0, 1.0, 0.0 );
         glVertex3fv( S5 );
         glVertex3fv( S1 );

         // glNormal3f( - M_SQRT1_2, - M_SQRT1_2, 0.0 );
         glNormal3f( -1.0, 0.0, 0.0 );
         glVertex3fv( S3 );
         glVertex3fv( S7 );
         glNormal3f( 0.0, -1.0, 0.0 );
         glVertex3fv( S6 );
         glVertex3fv( S2 );

         // glNormal3f( M_SQRT1_2, - M_SQRT1_2, 0.0 );
         glNormal3f( 0.0, -1.0, 0.0 );
         glVertex3fv( S2 );
         glVertex3fv( S6 );
         glNormal3f( 1.0, 0.0, 0.0 );
         glVertex3fv( S8 );
         glVertex3fv( S4 );

         glNormal3f( -1.0, 0.0, 0.0 );
         glVertex3fv( B3 );
         glVertex3fv( B1 );
         glVertex3fv( C1 );
         glVertex3fv( C3 );

         glVertex3fv( B3 );
         glVertex3fv( C3 );
         glVertex3fv( N5 );
         glVertex3fv( N3 );

         glNormal3f( 1.0, 0.0, 0.0 );
         glVertex3fv( C4 );
         glVertex3fv( C2 );
         glVertex3fv( B2 );
         glVertex3fv( B4 );

         glVertex3fv( C4 );
         glVertex3fv( B4 );
         glVertex3fv( N4 );
         glVertex3fv( N6 );
      glEnd();
      glBegin( GL_TRIANGLES );
         glNormal3f( - M_SQRT1_2, 0.0, M_SQRT1_2 );
         glVertex3fv( N1 );
         glVertex3fv( N3 );
         glVertex3fv( N2 );

         glNormal3f( M_SQRT1_2, 0.0, M_SQRT1_2 );
         glVertex3fv( N1 );
         glVertex3fv( N2 );
         glVertex3fv( N4 );
      glEnd();
      glBegin( GL_POLYGON );
         glNormal3f( 0.0, 0.0, -1.0 );
         glVertex3fv( N1 );
         glVertex3fv( N4 );
         glVertex3fv( B4 );
         glVertex3fv( B3 );
         glVertex3fv( N3 );
      glEnd();
   }
   else {

      glMaterialfv( GL_FRONT, GL_AMBIENT_AND_DIFFUSE, carColour );

      float x = 0.5;
      float y = 0.5*_length;
      float z1 = 0.2*_height;
      float z2 = 1.2*_height;

      float v1[ 3 ] = {  x,  y, z1 };
      float v2[ 3 ] = {  x,  y, z2 };
      float v3[ 3 ] = { -x,  y, z1 };
      float v4[ 3 ] = { -x,  y, z2 };
      float v5[ 3 ] = {  x, -y, z1 };
      float v6[ 3 ] = {  x, -y, z2 };
      float v7[ 3 ] = { -x, -y, z1 };
      float v8[ 3 ] = { -x, -y, z2 };

      if ( isWireFrame ) {
         glBegin( GL_LINES );
            glVertex3fv( v1 );
            glVertex3fv( v2 );
            glVertex3fv( v3 );
            glVertex3fv( v4 );
            glVertex3fv( v5 );
            glVertex3fv( v6 );
            glVertex3fv( v7 );
            glVertex3fv( v8 );
         glEnd();
         glBegin( GL_LINE_LOOP );
            glVertex3fv( v2 );
            glVertex3fv( v4 );
            glVertex3fv( v8 );
            glVertex3fv( v6 );
         glEnd();
         glBegin( GL_LINE_LOOP );
            glVertex3fv( v1 );
            glVertex3fv( v3 );
            glVertex3fv( v7 );
            glVertex3fv( v5 );
         glEnd();
      }
      else {
         glBegin( GL_QUADS );

            glNormal3f( 0.0, 0.0, 1.0 );
            glVertex3fv( v2 );
            glVertex3fv( v4 );
            glVertex3fv( v8 );
            glVertex3fv( v6 );

            glNormal3f( 0.0, 0.0, -1.0 );
            glVertex3fv( v1 );
            glVertex3fv( v5 );
            glVertex3fv( v7 );
            glVertex3fv( v3 );

            glNormal3f( 1.0, 0.0, 0.0 );
            glVertex3fv( v1 );
            glVertex3fv( v2 );
            glVertex3fv( v6 );
            glVertex3fv( v5 );

            glNormal3f( -1.0, 0.0, 0.0 );
            glVertex3fv( v7 );
            glVertex3fv( v8 );
            glVertex3fv( v4 );
            glVertex3fv( v3 );

            glNormal3f( 0.0, 1.0, 0.0 );
            glVertex3fv( v3 );
            glVertex3fv( v4 );
            glVertex3fv( v2 );
            glVertex3fv( v1 );

            glNormal3f( 0.0, -1.0, 0.0 );
            glVertex3fv( v5 );
            glVertex3fv( v6 );
            glVertex3fv( v8 );
            glVertex3fv( v7 );

            glNormal3f( 0.0, 0.0, 1.0 );

         glEnd();
      }
   }

   popLevel();
}

