
#ifndef TRAIN_H
#define TRAIN_H


#include "TrainCar.h"
#include "global.h"


class Train {

   bool _isEngineOn;
   float _speed;  // of the first car, and everything it's pulling
   float _acceleration;  // of the first car

   static const float _cruisingSpeed;
   static const float _startingAcceleration;
   static const float _accelerationUnderNoPower;
   static const float _breakingAcceleration;

   typedef struct {
      TrainCar * car;
      bool isAlive;
      float speedOfNextCar;  // only used if car is dead
   } TrainCarStruct;
   typedef TrainCarStruct * TrainCarStructPtr;

   int _numberOfCars;
   TrainCarStruct ** _arrayOfCars;

   AbstractTrainTrack * _initial_track;
   float _initial_distanceAlongTrack;
   TrainCar::TrainCarDirection _initial_directionAlongTrack;

public:

   typedef struct {
      float x, y, z;
      float radius;
   } Sphere;

   Train(
      AbstractTrainTrack * track,
      float distanceAlongTrack,
      TrainCar::TrainCarDirection directionAlongTrack
   ) :
      _isEngineOn( false ), _speed( 0.0 ), _acceleration( 0.0 ),
      _numberOfCars( 0 ), _arrayOfCars( NULL ),
      _initial_track( track ),
      _initial_distanceAlongTrack( distanceAlongTrack ),
      _initial_directionAlongTrack( directionAlongTrack )
   {
   }

   ~Train();

   void reset();
   void start() { _isEngineOn = true; _acceleration = _startingAcceleration; }
   void stop() { _isEngineOn = false; _acceleration = _breakingAcceleration; }
   bool advance( float delta_time, bool & startingPointPassed );
   void draw( LevelOfDetail LOD, bool isWireFrame );
   bool isEngineOn() { return _isEngineOn; }

   void appendCar( TrainCar::TrainCarType carType );
   void appendCar(
      TrainCar::TrainCarType carType,
      float colourRed, float colourGreen, float colourBlue
   );
   int getLength() { return _numberOfCars; }
   const TrainCar * getCar( int index ) {
      return ( 0 <= index && index < _numberOfCars )
         ? _arrayOfCars[ index ]->car : NULL;
   }
   void removeCar( int index );
   void getBoundingGeometry( Sphere * arrayOfSpheres );
   static void performCollisionTest(
      int numberOfCarsForTrain1, Sphere * geometryOfTrain1,
      int numberOfCarsForTrain2, Sphere * geometryOfTrain2,
      bool * carCollisionsForTrain1, bool * carCollisionsForTrain2
   );
};


#endif /* TRAIN_H */

