
#ifndef SECTIONOFTRAINTRACK_H
#define SECTIONOFTRAINTRACK_H


#include "global.h"


class SectionOfTrainTrack {
protected:
   float _length;

   float _start_x;
   float _start_y;
   float _start_z;
   float _start_direction_x;
   float _start_direction_y;
   float _start_direction_z;

   SectionOfTrainTrack(
      float length,
      float start_x,
      float start_y,
      float start_z,
      float start_direction_x,
      float start_direction_y,
      float start_direction_z
   );
public:
   float getLength() { return _length; }
   virtual void computePositionAndDirection(
      float distanceAlongTrack,
      float & x,
      float & y,
      float & z,
      float & direction_x,
      float & direction_y,
      float & direction_z
   ) = 0;
};

// ==================================================

class StraightSection : public SectionOfTrainTrack {
public:
   StraightSection(
      float length,
      float start_x,
      float start_y,
      float start_z,
      float start_direction_x,
      float start_direction_y,
      float start_direction_z
   ) :
      SectionOfTrainTrack(
         length,
         start_x, start_y, start_z,
         start_direction_x, start_direction_y, start_direction_z
      )
   {}
   virtual void computePositionAndDirection(
      float distanceAlongTrack,
      float & x,
      float & y,
      float & z,
      float & direction_x,
      float & direction_y,
      float & direction_z
   );
};

// ==================================================

class CurvedSection : public SectionOfTrainTrack {
   float _arc_angle_in_radians;  // negative means a clockwise turn
   float _radius;
   float _hypotenuse;
   float _start_theta;
   float _arc_center_x;
   float _arc_center_y;
public:
   CurvedSection(
      float arc_angle_in_radians,
      float radius,
      float start_x,
      float start_y,
      float start_z,
      float start_direction_x,
      float start_direction_y,
      float start_direction_z
   );
   virtual void computePositionAndDirection(
      float distanceAlongTrack,
      float & x,
      float & y,
      float & z,
      float & direction_x,
      float & direction_y,
      float & direction_z
   );
};


#endif /* SECTIONOFTRAINTRACK_H */

