
#ifndef ROTATOR_H
#define ROTATOR_H


#include "global.h"


class Rotator {

   typedef enum {
      elevationAzimuth = 0,
      aroundXYAxes,
      virtualSphere,
      arcball,
      numberOfRotationModes
   } RotationMode;

   float _center_x, _center_y, _radius;
   RotationMode _rotationMode;
   float _oldRotationMatrix[16];   // cumulative past rotations
   float _rotationMatrix[16];   // oldRotationMatrix + current rotation

   // stuff specific to "elevationAzimuth" mode
   float _elevation, _azimuth;   // in degrees; not radians
public:
   Rotator(
      float center_x,
      float center_y,
      float radius
   ) :
      _center_x( center_x ),
      _center_y( center_y ),
      _radius( radius ),
      _rotationMode( elevationAzimuth ),
      _elevation(0.0),
      _azimuth(0.0)
   {
      assignToUnity( _oldRotationMatrix );
      assignToUnity( _rotationMatrix );
   }

   void resize( float center_x, float center_y, float radius ) {
      _center_x = center_x;
      _center_y = center_y;
      _radius = radius;
   }

   RotationMode getRotationMode() { return _rotationMode; }
   void setRotationMode( RotationMode newMode );
   void cycleRotationMode() {
      setRotationMode(
         (RotationMode)((_rotationMode+1) % (numberOfRotationModes))
      );
   }

   float * getRotationMatrix() { return _rotationMatrix; }
   void deviceMotion( float x1, float y1, float x2, float y2 );
};


#endif /* ROTATOR_H */

