
#ifndef MENU_H
#define MENU_H


#include <X11/Xlib.h>


class Menu {

   typedef struct {
      char * label;
      char * description;
      int clientData;
      int labelWidthInPixels;
      float menuItemWidthInPixels;
   } MenuItem;
   typedef MenuItem * MenuItemPtr;

   Display * _display;
   Window _window;
   XFontStruct * _font;

   int _x1, _y1, _x2, _y2;
   int _sumOfLabelWidthsInPixels;
   int _numberOfMenuItems;
   MenuItem ** _menuItems;

   static const int NO_MENU_ITEM = -1;

   int _menuItemBeingClicked;

   bool _needToRecomputeGeometry;

   void computeGeometry();
   int findMenuItemUnderPoint( int x, int y );

public:

   static const int NO_CLIENT_DATA = -1;

   Menu(
      Display * display, Window window, XFontStruct * font,
      int x1, int y1, int x2, int y2
   ) :
      _display( display ), _window( window ), _font( font ),
      _x1( x1 ), _y1( y1 ), _x2( x2 ), _y2( y2 ),
      _sumOfLabelWidthsInPixels( 0 ),
      _numberOfMenuItems( 0 ), _menuItems( NULL ),
      _menuItemBeingClicked( NO_MENU_ITEM ),
      _needToRecomputeGeometry( false )
   { }

   ~Menu();

   void resize( int x1, int y1, int x2, int y2 ) {
      _x1 = x1;   _y1 = y1;   _x2 = x2;   _y2 = y2;
      _needToRecomputeGeometry = true;
   }

   void appendMenuItem( char * label, char * description, int clientData );

   void buttonDown( int x, int y );
   int buttonUp( int x, int y );
   const char * getDescription( int x, int y );

   void draw(
      GC gc, unsigned long foregroundColour, unsigned long backgroundColour
   );
};


#endif /* MENU_H */

