
#include "Menu.h"
#include <string.h>


void Menu::computeGeometry() {

   int menuWidthInPixels = _x2 - _x1 + 1;

   int j;

   _sumOfLabelWidthsInPixels = 0;

   for ( j = 0; j < _numberOfMenuItems; ++j ) {
      _menuItems[ j ]->labelWidthInPixels = XTextWidth(
         _font, _menuItems[ j ]->label, strlen( _menuItems[ j ]->label )
      );
      _sumOfLabelWidthsInPixels += _menuItems[ j ]->labelWidthInPixels;
   }

   for ( j = 0; j < _numberOfMenuItems; ++j ) {
      _menuItems[ j ]->menuItemWidthInPixels
         = _menuItems[ j ]->labelWidthInPixels
         / (float)_sumOfLabelWidthsInPixels * menuWidthInPixels;
   }
}

int Menu::findMenuItemUnderPoint( int x, int y ) {

   int returnValue = NO_MENU_ITEM;

   if ( _y1 <= y && y <= _y2 ) {
      float min_x = _x1;
      for ( int j = 0; j < _numberOfMenuItems; ++j ) {
         if (
            min_x <= x && x <= min_x + _menuItems[ j ]->menuItemWidthInPixels
         ) {
            returnValue = j;
            break;
         }
         min_x += _menuItems[ j ]->menuItemWidthInPixels;
      }
   }

   return returnValue;
}

Menu::~Menu() {

   for ( int j = 0; j < _numberOfMenuItems; ++j ) {
      delete [] _menuItems[ j ]->label;
      delete [] _menuItems[ j ]->description;
      delete _menuItems[ j ];   _menuItems[ j ] = NULL;
   }
   delete [] _menuItems; _menuItems = NULL;
   _numberOfMenuItems = 0;
}

void Menu::appendMenuItem( char * label, char * description, int clientData ) {

   // Make room for the new item: enlarge the array by one
   //
   {
      MenuItem ** newMenuItemArray = new MenuItemPtr[ _numberOfMenuItems + 1 ];
      for ( int j = 0; j < _numberOfMenuItems; ++j )
         newMenuItemArray[ j ] = _menuItems[ j ];
      newMenuItemArray[ _numberOfMenuItems ] = NULL;
      delete [] _menuItems;
      _menuItems = newMenuItemArray;
      ++ _numberOfMenuItems;
   }

   // Create the new menu item and copy data into it
   //
   MenuItem * newMenuItem = new MenuItem;
   newMenuItem->label = new char [ strlen( label ) + 1 ];
   strcpy( newMenuItem->label, label );
   newMenuItem->description = new char [ strlen( description ) + 1 ];
   strcpy( newMenuItem->description, description );
   newMenuItem->clientData = clientData;
   newMenuItem->labelWidthInPixels = XTextWidth(
      _font, label, strlen( label )
   );
   _sumOfLabelWidthsInPixels += newMenuItem->labelWidthInPixels;

   // Add menu item to the array.
   //
   _menuItems[ _numberOfMenuItems - 1 ] = newMenuItem;

   _needToRecomputeGeometry = true;
}

void Menu::buttonDown( int x, int y ) {

   _menuItemBeingClicked = findMenuItemUnderPoint( x, y );
}

int Menu::buttonUp( int x, int y ) {

   int returnValue = NO_CLIENT_DATA;

   int j = findMenuItemUnderPoint( x, y );
   if ( j == _menuItemBeingClicked && NO_MENU_ITEM != j ) {
      // The user clicked down and released over the same menu item.
      // Hence the user succesfully selected the menu item.
      returnValue = _menuItems[ _menuItemBeingClicked ]->clientData;
   }

   _menuItemBeingClicked = NO_MENU_ITEM;
   return returnValue;
}

const char * Menu::getDescription( int x, int y ) {

   int j = findMenuItemUnderPoint( x, y );
   return ( NO_MENU_ITEM != j ) ? _menuItems[ j ]->description : NULL;
}

void Menu::draw(
   GC gc, unsigned long foregroundColour, unsigned long backgroundColour
) {

   XSetFont( _display, gc, _font->fid );

   if ( _needToRecomputeGeometry ) {
      computeGeometry();
      _needToRecomputeGeometry = false;
   }

   float x = _x1;
   int y = (( _y2 - _y1 + 1 ) - ( _font->ascent + _font->descent )) / 2
         + _font->ascent;

   for ( int j = 0; j < _numberOfMenuItems; ++j ) {

      // If this menu item is being pressed, highlight it.
      //
      if ( j == _menuItemBeingClicked ) {
         static const int M = 0;   // margin width
         XFillRectangle(
            _display, _window, gc,
            (int)( x + 0.5 ) + M,
            _y1 + M,
            (int)( _menuItems[ j ]->menuItemWidthInPixels + 0.5 ) - 2*M,
            _y2 - _y1 - 2*M
         );
         XSetForeground( _display, gc, backgroundColour );
      }

      float offset = 0.5 * ( _menuItems[ j ]->menuItemWidthInPixels
         - _menuItems[ j ]->labelWidthInPixels );
      XDrawString(
         _display, _window, gc,
         (int)( x + offset + 0.5 ), y,
         _menuItems[ j ]->label, strlen( _menuItems[ j ]->label )
      );

      if ( j == _menuItemBeingClicked ) {
         XSetForeground( _display, gc, foregroundColour );
      }

      x += _menuItems[ j ]->menuItemWidthInPixels;

      // if this is not the last menu item, draw a vertical bar
      //
      if ( j < _numberOfMenuItems - 1 ) {
         XDrawLine(
            _display, _window, gc,
            (int)( x + 0.5 ), _y1, (int)( x + 0.5 ), _y2
         );
      }
   }

   XDrawLine( _display, _window, gc, _x1, _y2, _x2, _y2 );
}

