
#ifndef EXPLOSION_H
#define EXPLOSION_H


#include "TrainCar.h"
#include "global.h"
#include <stdlib.h>


class Explosion {

   float _x, _y, _z;
   float _time;
   static const float _duration;

public:

   Explosion( const TrainCar * trainCar ) : _time( 0.0 ) {
      trainCar->getPosition( _x, _y, _z );
      // randomize the explosion's center
      float l = trainCar->getLength();
      _x += ((rand() / (float)(RAND_MAX))-0.5) * l;
      _y += ((rand() / (float)(RAND_MAX))-0.5) * l;
      _z += 0.5 * trainCar->getHeight()
            + ((rand()/(float)(RAND_MAX))-0.5) * 0.2 * l;
   }

   void burn( float delta_time ) { _time += delta_time; }
   bool isStillBurning() { return _time <= _duration; }
   void draw( LevelOfDetail LOD, bool isWireFrame );
};


#endif /* EXPLOSION_H */

