
#include "Explosion.h"
#include <GL/gl.h>


const float Explosion::_duration = 1.5;


void Explosion::draw( LevelOfDetail LOD, bool isWireFrame ) {

   if ( _time <= _duration ) {
      float t = _time/_duration;
      GLfloat fireColour[] = { 1.0, 0.75 - t*0.5, 0.0, 0.0 };
      glMaterialfv( GL_FRONT, GL_AMBIENT_AND_DIFFUSE, fireColour );
      drawSphere( _x, _y, _z, (1.0-2.0*fabs(t-0.5)) * 2.0 + 1.5, LOD );
   }
}

