
#ifndef CAMERA_H
#define CAMERA_H


#include "Rotator.h"


class Camera {
protected:
   int _window_width, _window_height;
   int _viewport_x1, _viewport_y1, _viewport_x2, _viewport_y2;
   int _viewport_cx, _viewport_cy;
   int _viewport_radius_in_pixels;

   float _initial_viewport_radius, _viewport_radius;
   float _viewport_width;
   float _viewport_height;
   float _initial_near_plane, _near_plane, _initial_far_plane, _far_plane;

   Camera(
      int window_width, int window_height,
      int viewport_x1, int viewport_y1,
      int viewport_x2, int viewport_y2,
      float viewport_radius,
      float near_plane, float far_plane
   );
public:
   virtual void reset();
   virtual void invokeTransform();
   virtual void resizeViewport(
      int window_width, int window_height,
      int viewport_x1, int viewport_y1,
      int viewport_x2, int viewport_y2
   );

   // Changes the field-of-view.
   //
   void zoomIn( float delta_pixels );
};

// ==================================================

class OrbitingCamera : public Camera {
    static const float _radiusMultiplier;
    static const float _nearPlaneFactor;
    static const float _fudgeFactor;

    Rotator _rotator;
    float _initial_distance_from_POI, _distance_from_POI;

    // POI means "point of interest", the point around
    // which the camera orbits.
    //
    float _initial_POI_x, _initial_POI_y, _initial_POI_z;
    float _POI_x, _POI_y, _POI_z;

public:
   OrbitingCamera(
      int window_width, int window_height,
      int viewport_x1, int viewport_y1,
      int viewport_x2, int viewport_y2,
      float POI_x, float POI_y, float POI_z,
      float radius_of_scene
   );
   virtual void reset();
   virtual void invokeTransform();
   virtual void resizeViewport(
      int window_width, int window_height,
      int viewport_x1, int viewport_y1,
      int viewport_x2, int viewport_y2
   );

   // This "orbits" the camera, causing the scene to "tumble".
   //
   void orbit(
      float old_x_pixels, float old_y_pixels,
      float new_x_pixels, float new_y_pixels
   );

   // Translates the point-of-interest in the camera plane.
   // Also translates the camera by a same amount.
   // Effectively *moves* the camera up/down/right/left,
   // without changing its orientation.
   // Some may refer to this as "panning" the camera.
   //
   void translateSceneRightAndUp( float delta_x_pixels, float delta_y_pixels );

   // Moves the camera forward or backward.  Some refer to
   // this as "tracking" the camera.
   //
   void dollyCameraForward( float delta_pixels );

   // Rolls the camera.  (NOT YET IMPLEMENTED)
   //
   // void rollCameraRight( float delta_pixels );
};

// ==================================================

class FreeFloatingCamera : public Camera {
   float _cumulativeTransforms[16];
   float _translationSpeedInUnitsPerRadius;
   float _rotationSpeedInDegreesPerRadius;
public:
   FreeFloatingCamera(
      int window_width, int window_height,
      int viewport_x1, int viewport_y1,
      int viewport_x2, int viewport_y2,
      float viewport_radius,
      float near_plane, float far_plane,
      float translationSpeedInUnitsPerRadius,
      float rotationSpeedInDegreesPerRadius
   );
   virtual void reset();
   virtual void invokeTransform();
   void invokeTransformWithOffset(
      float position_x, float position_y, float position_z,
      float direction_x, float direction_y, float direction_z
   );

   // Changes the elevation angle of the camera.
   // Some refer to this as "tilting" the camera.
   //
   void pitchCameraUp( float delta_pixels );

   // Changes the azimuth angle of the camera.
   // Some refer to this as "panning" the camera.
   //
   void yawCameraRight( float delta_pixels );

   // Translates or *moves* the camera up/down/right/left.
   // Some may refer to this as "panning" the camera.
   //
   void translateCameraRightAndUp(
      float delta_x_pixels, float delta_y_pixels
   );

   // Moves the camera forward or backward.  Some refer to
   // this as "tracking" the camera.
   //
   void dollyCameraForward( float delta_pixels );

   // Rolls the camera.
   //
   void rollCameraRight( float delta_pixels );
};


#endif /* CAMREA_H */

