
#ifndef ABSTRACTTRAINTRACK_H
#define ABSTRACTTRAINTRACK_H


#include "global.h"


#define TRAIN_TRACK_WIDTH (1.0)


class AbstractTrainTrack {
public:

   typedef enum {
      INITIAL_END_POINT,
      FINAL_END_POINT
   } TrackEndPoint;

   virtual float getLength() = 0;
   virtual void computePositionAndDirection(
      float distanceAlongTrack,
      float & x,
      float & y,
      float & z,
      float & direction_x,
      float & direction_y,
      float & direction_z
   ) = 0;
   virtual void connect(
      TrackEndPoint endToConnect,
      AbstractTrainTrack * trackToConnectTo,
      TrackEndPoint endToConnectTo
   ) = 0;
   virtual void disconnect( TrackEndPoint endToDisconnect ) = 0;
   virtual void getConnection(
      TrackEndPoint connectedEnd,
      AbstractTrainTrack * & trackConnectedTo,
      TrackEndPoint & endConnectedTo
   ) = 0;
};


#endif /* ABSTRACTTRAINTRACK_H */

